@extends('admin.layouts.app')

@section('title', 'Data User')

@section('content')

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-1">Data User</h4>
            <small class="text-muted">Manajemen akun pengguna</small>
        </div>

        <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#tambahJabatan">
            <i class="fas fa-plus me-2"></i>Tambah Data
        </button>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">

            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Nama Jabatan</th>
                        <th>Tipe Gaji</th>
                        <th>Gaji Pokok</th>
                        <th>Gaji Harian</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($jabatan as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->nama_jabatan }}</td>
                            <td>
                                <span class="badge bg-info text-dark">
                                    {{ $item->tipe_gaji }}
                                </span>
                            </td>
                            <td>{{ $item->gaji_pokok }}</td>
                            <td>{{ $item->gaji_harian }}</td>

                            <td class="text-center">
                                <button data-bs-target="#ubahJabatan{{ $item->id }}" data-bs-toggle="modal"
                                    class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                    data-bs-target="#hapusJabatan{{ $item->id }}">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
        @foreach ($jabatan as $item)
            @include('admin.jabatan.edit')
            @include('admin.jabatan.delete')
        @endforeach
    </div>
    @include('admin.jabatan.create')


@endsection
